/**************************************************************************
***    
*** Copyright (c) 1995-2000 Regents of the University of California,
***               Andrew E. Caldwell, Andrew B. Kahng and Igor L. Markov
***
***  Contact author(s): abk@cs.ucla.edu, imarkov@cs.ucla.edu
***  Affiliation:   UCLA, Computer Science Department,
***                 Los Angeles, CA 90095-1596 USA
***
***  Permission is hereby granted, free of charge, to any person obtaining 
***  a copy of this software and associated documentation files (the
***  "Software"), to deal in the Software without restriction, including
***  without limitation 
***  the rights to use, copy, modify, merge, publish, distribute, sublicense, 
***  and/or sell copies of the Software, and to permit persons to whom the 
***  Software is furnished to do so, subject to the following conditions:
***
***  The above copyright notice and this permission notice shall be included
***  in all copies or substantial portions of the Software.
***
*** THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
*** EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
*** OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. 
*** IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
*** CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT
*** OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR
*** THE USE OR OTHER DEALINGS IN THE SOFTWARE.
***
***
***************************************************************************/

//! author="Igor Markov" 

/* June 17, 1997  imarkov   added abkguess()
 June 17, 1997  imarkov   added abkassert_stop_here(), abkguess_stop_here()
 970824   ilm   added endl before assert/fatal/warn/guess messages
 970923   ilm   added abk_dump_stack()
 980303   ilm   added abk_dump_stack()

 This file to be included into all projects in the group
*/

#ifndef  _ABKASSERT_H_
#define  _ABKASSERT_H_

//:  name abkassert_stop_here(); abkguess_stop_here(); ....
//   Breakpoints for abkassert, abkguess, abkfatal, abkwarn
//   When  debugging, you can put breakpoints in abkassert_stop_here(),
//   but this should be redundant since abkassert() is always fatal
extern void abkassert_stop_here();
extern void  abkguess_stop_here();

extern void  abkfatal_stop_here();
extern void   abkwarn_stop_here();

//: defined in platfDepend.cxx 
extern void   abk_dump_stack();    
//: defined in platfDepend.cxx 
extern void   abk_call_debugger();  

#ifdef ABKDEBUG
#define STACK_DUMP abk_dump_stack();
#define abkfatal_breakpoint abkfatal_stop_here();
#define abkwarn_breakpoint abkwarn_stop_here();
#else
#define STACK_DUMP (void) 0;
#define abkfatal_breakpoint (void) 0;
#define abkwarn_breakpoint (void) 0;
#endif

const char* SgnPartOfFileName(const char * fileName);

char* BaseFileName(char *filename);

#ifdef ABKDEBUG
//: if ABKDEBUG is defined it checks the condition and
// if it fails, prints the message. If NDEBUG is not
// defined, it prints line number and filename, then stops.
// If NDEBUG is defined, it continues (standard ssert.h behavior)
// To have ABKDEBUG defined, your compiler should use -DDEBUG argument
// Otherwise, there is 0 overhead to have abkassert()
#define abkassert(CONDITION, ERRMESSAGE)                                \
        {  if (!(CONDITION))                                            \
       {  cerr << endl << (ERRMESSAGE) << endl;                         \
          cerr << "  (Error in " << SgnPartOfFileName(__FILE__)         \
                                       << ":" << __LINE__  <<")"<<endl; \
          abk_dump_stack();                                             \
          abkassert_stop_here();                                        \
          abort();                         /* Armageddon now */         \
       }                                                                \
    }                               
#else
#define abkassert(CONDITION, ERRMESSAGE) ((void) 0)
#endif

//        char * __p=(char *) 0;__p[0]=0;  /* Armageddon now */         

#ifdef ABKDEBUG
#define abkassert2(CONDITION, ERR1, ERR2)                               \
        {  if (!(CONDITION))                                            \
       {  cerr << endl << (ERR1) << (ERR2) << endl;                     \
          cerr << "  (Error in " << SgnPartOfFileName(__FILE__)         \
                                       << ":" << __LINE__  <<")"<<endl; \
          abk_dump_stack();                                             \
          abkassert_stop_here();                                        \
          abort();                                                      \
       }                                                                \
    }                               
#else
#define abkassert2(CONDITION, ERR1, ERR2) ((void) 0)
#endif

#ifdef ABKDEBUG
#define abkassert3(CONDITION, ERR1, ERR2, ERR3)                         \
        {  if (!(CONDITION))                                            \
       {  cerr << endl << (ERR1) << (ERR2) <<(ERR3) << endl;            \
          cerr << "  (Error in " << SgnPartOfFileName(__FILE__)         \
                                       << ":" << __LINE__  <<")"<<endl; \
          abk_dump_stack();                                             \
          abkassert_stop_here();                                        \
          abort();                                /* Armageddon now */  \
       }                                                                \
    }                               
#else
#define abkassert3(CONDITION, ERR1, ERR2, ERR3) ((void) 0)
#endif

#ifdef ABKDEBUG
//: Same as abkassert, but does not stop the program.
#define abkguess(CONDITION, ERRMESSAGE)                                 \
        {  if (!(CONDITION))                                            \
       {  cerr << endl << (ERRMESSAGE);                                 \
          cerr << " in line "<<__LINE__<<", file "<<__FILE__<<endl;     \
          abkguess_stop_here();                                         \
       }                                                                \
    }                               
#else
#define abkguess(CONDITION, ERRMESSAGE) ((void) 0)
#endif

#ifdef ABKDEBUG
#define abkguess2(CONDITION, ERR1,ERR2 )                                \
        {  if (!(CONDITION))                                            \
       {  cerr << endl << (ERR1) << (ERR2);                             \
          cerr << " in line "<<__LINE__<<", file "<<__FILE__<<endl;     \
          abkguess_stop_here();                                         \
       }                                                                \
    }                               
#else
#define abkguess2(CONDITION, ERR1, ERR2) ((void) 0)
#endif

#ifdef ABKDEBUG
#define abkguess3(CONDITION,ERR1,ERR2,ERR3)                             \
        {  if (!(CONDITION))                                            \
       {  cerr << endl << (ERR1) << (ERR2) << (ERR3);                   \
          cerr << " in line "<<__LINE__<<", file "<<__FILE__<<endl;     \
          abkguess_stop_here();                                         \
       }                                                                \
    }                               
#else
#define abkguess3(CONDITION, ERR1, ERR2) ((void) 0)
#endif

//: just like abkassert(), but does not depend on  whether
// a symbol is defined. "unconditional assertion"
// should be used in all noncritical places
#define abkfatal(CONDITION, ERRMESSAGE)                                 \
        {  if (!(CONDITION))                                            \
       {  cerr << endl << (ERRMESSAGE) ;                                \
          cerr<<"  (Fatal error in " << SgnPartOfFileName(__FILE__)     \
                                       << ":" << __LINE__  <<")"<<endl; \
          STACK_DUMP;                                                   \
          abkfatal_breakpoint;                                          \
          abort();                                                      \
       }                                                                \
    }                               

#define abkfatal2(CONDITION, ERR1, ERR2)                                \
        {  if (!(CONDITION))                                            \
       {  cerr << endl << (ERR1) << (ERR2);                             \
          cerr<<"  (Fatal error in " << SgnPartOfFileName(__FILE__)     \
                                       << ":" << __LINE__  <<")"<<endl; \
          STACK_DUMP;                                                   \
          abkfatal_breakpoint;                                          \
          abort();                                                      \
       }                                                                \
    }                               

#define abkfatal3(CONDITION, ERR1, ERR2, ERR3)                          \
        {  if (!(CONDITION))                                            \
       {  cerr << endl << (ERR1) << (ERR2) << (ERR3);                   \
          cerr<<"  (Fatal error in " << SgnPartOfFileName(__FILE__)     \
                                       << ":" << __LINE__  <<")"<<endl; \
          STACK_DUMP;                                                   \
          abkfatal_breakpoint;                                          \
          abort();                                                      \
       }                                                                \
    }                               

//: just like abkguess() 3d, but does not depend whether
// a symbol is defined. "unconditional warning"
// should be used in all noncritical places
#define abkwarn(CONDITION, ERRMESSAGE)                                  \
        {  if (!(CONDITION))                                            \
       {  cerr << endl << (ERRMESSAGE);                                 \
          cerr << " (Warning in " << SgnPartOfFileName(__FILE__)        \
                                     << ":" << __LINE__ <<")"<<endl;    \
          abkwarn_breakpoint;                                           \
       }                                                                \
    }
                               
#define abkwarn2(CONDITION, ERR1, ERR2)                                 \
        {  if (!(CONDITION))                                            \
       {  cerr << endl << (ERR1) << (ERR2);                             \
          cerr << " (Warning in " << SgnPartOfFileName(__FILE__)        \
                                     << ":" << __LINE__ <<")"<<endl;    \
          abkwarn_breakpoint;                                           \
       }                                                                \
    }

#define abkwarn3(CONDITION, ERR1, ERR2, ERR3)                           \
        {  if (!(CONDITION))                                            \
       {  cerr << endl << (ERR1) << (ERR2) << (ERR3);                   \
          cerr << " (Warning in " << SgnPartOfFileName(__FILE__)        \
                                     << ":" << __LINE__ <<")"<<endl;    \
          abkwarn_breakpoint;                                           \
       }                                                                \
    }
#endif
