
// Created by Igor L. Markov, 010102

#include "nameMe.h"
#include "UTIL/infolines.h"
#include "UTIL/timer.h"
#include <iostream>

int main(int argc, const char *argv[])
{
   Timer tm;
   MemUsage mu;  // memory usage computed at construction time
   cout << endl;
   cout << "Current memory usage is: " << mu.getMem() << " Mb" << endl << endl;
   cout << SysInfo();
   cout << "*** Producing sys info and printing it"
           " resulted in additional memory usage ! " << endl;
   tm.stop();
   cout << " So far, everything took " << tm << endl;
   cout << " If you see a time reading of less than 0.01 sec, "
        << " it may be unreliable " << endl << endl;

   cout << "*** Now let's measure the time taken by the sqrt() call.\n"
           " For this, repeat the call many times ... " << flush;
   Timer tm1;  // timer starts at construction; 
               // it can also be stopped and re-started later
   unsigned i;
   double   d;
   const unsigned SampleSize=100000;
   for(i=0; i!=SampleSize; i++) 
   {             // note that we are now measuring the loop
     d=sqrt(i);  // itself in addition to measuring the sqrt() call
     d=sqrt(i);  // therefore, we repeat sqrt() calls many times in the loop
     d=sqrt(i);  // to better amortize loop operations over sqrt() calls 

     d=sqrt(i);
     d=sqrt(i);
     d=sqrt(i);

     d=sqrt(i);
     d=sqrt(i);
     d=sqrt(i);

     d=sqrt(i);
   }
   tm1.stop();
   cout << "done \n";
   cout << " The computation took " << tm1 << endl;
   cout << " Estimated cost of one sqrt call is " 
        << tm1.getUserTime() / (SampleSize * 10) << " seconds " << endl;
   
   return 0;
}
