`define DATA_WIDTH 16

module DDSRAM2 (	clock,    //clock at fs
						FTV,	  //Frequency tuning value
						dataOut,   //DATA_WIDETH bits data value we want to output.
						iDataOut
				);

//DDSRAM with linear interpolation

input 			clock;							
output			[`DATA_WIDTH-1:0]			dataOut;  	//Data to output.
output 			[`DATA_WIDTH-1:0]			iDataOut;

wire 				[`DATA_WIDTH-1:0] 		dataOut2;	//Lookahead by 1
wire 				[`DATA_WIDTH-1:0] 		dataOutTemp;


input [16:0] 	FTV;
reg	[15:0] 	counter;
wire 	[15:0] 	counter2;

wire 				[`DATA_WIDTH-1:0] delta;
assign			delta = dataOut2 - dataOutTemp; 

wire	[31:0]	weighted; //weighted difference, 32 bit arithmetic
assign 			weighted = $signed(delta)*$signed({6'h00,counter[9:0]}); //16Q15 x 16Q10 => 32Q25
wire	[15:0] 	temp = $signed(dataOut)+ $signed(weighted[25:10]);
assign 			iDataOut 	= {temp[15],temp[15:1]};
assign 			dataOut 		= {dataOutTemp[15], dataOutTemp[15:1]};

always@(negedge clock)
begin
	counter <= counter + FTV;
end

assign counter2 = counter + 11'b10000000000; //lookahead
sineROM	sineRom_inst (
	.address_a ( counter[15:10] ),
	.address_b ( counter2[15:10] ),
	.clock ( clock ),
	.q_a ( dataOutTemp ),
	.q_b ( dataOut2 )
);
endmodule 
