module statem(clk, in, reset, out);

input clk, in, reset;
output [3:0] out;

reg [3:0] out;
reg [1:0] state;
reg [1:0] next_state;

parameter zero=2'd0, one=2'd1, two=2'd2, three=2'd3;

always @*
     begin
          case (state)
               zero:
			begin
                out = 4'b0000;
				next_state = one;
			end
               one:
			begin
                out = 4'b0001;
				if(in)
					next_state = one;
				else
					next_state = two;
			end
               two:
			begin
                out = 4'b0010;
				if(in)
					next_state = one;
				else
					next_state = three;
			end
               three:
			begin
                out = 4'b0100;
				next_state = zero;
			end
               default:
			begin
                out = 4'b0000;
				next_state = zero;
			end
          endcase
     end

always @(posedge clk)
     begin
          if (reset)
               state <= zero;
          else
               state <= next_state;
     end

endmodule
