`define DATA_WIDTH 16

module AUDIO
	(
		////////////////////	Clock Input	 		////////////////////	 
		iCLK_50,							//	50 MHz External Clock
		////////////////////	value for output	////////////////////
		value,							//	value to output
		////////////////	Audio CODEC		////////////////////////
		AUD_ADCLRCK,					//	Audio CODEC ADC LR Clock
		iAUD_ADCDAT,					//	Audio CODEC ADC Data
		AUD_DACLRCK,					//	Audio CODEC DAC LR Clock
		oAUD_DACDAT,					//	Audio CODEC DAC Data
		AUD_BCLK,						//	Audio CODEC Bit-Stream Clock
		oAUD_XCK,						//	Audio CODEC Chip Clock
	   
	);

//===========================================================================
// PARAMETER declarations
//===========================================================================
parameter	REF_CLK			=	18432000;	//	18.432	MHz
parameter	SAMPLE_RATE		=	48000;		//	48		KHz
parameter	CHANNEL_NUM		=	2;			//	Dual Channel


//===========================================================================
// PORT declarations
//===========================================================================
////////////////////////	Clock Input	 	////////////////////////
input			iCLK_50;				//	50 MHz
////////////////////////	Push Button		////////////////////////
////////////////////////	DPDT Switch		////////////////////////
input	[`DATA_WIDTH-1:0]	value;					//	Toggle Switch[8:0]

////////////////////	Audio CODEC		////////////////////////////
inout			AUD_ADCLRCK;			//	Audio CODEC ADC LR Clock
input			iAUD_ADCDAT;			//	Audio CODEC ADC Data
inout			AUD_DACLRCK;			//	Audio CODEC DAC LR Clock
output			oAUD_DACDAT;			//	Audio CODEC DAC Data
inout	reg		AUD_BCLK;				//	Audio CODEC Bit-Stream Clock
output			oAUD_XCK;				//	Audio CODEC Chip Clock

///////////////////////////////////////////////////////////////////
//=============================================================================
// REG/WIRE declarations
//=============================================================================


wire	CPU_CLK;
wire	CPU_RESET;
wire	CLK_18_4;
wire	CLK_25;

//	For Audio CODEC
wire		iCLK_18_4;	//	For Audio Controller

assign	oAUD_XCK	=	iCLK_18_4;
assign	AUD_ADCLRCK	=	AUD_DACLRCK;

//	Reset Delay Timer
Reset_Delay			r0	(	.iCLK(iCLK_50),.oRESET(iRST_N)	);
clock c1(~iRST_N, iCLK_50, iCLK_18_4);


reg		[3:0]	BCK_DIV;
reg		[8:0]	LRCK_1X_DIV;
reg		[3:0]	SEL_Cont;
////////	DATA Counter	////////


////////////////////////////////////

reg		LRCK_1X;


////////////	AUD_BCK Generator	//////////////
always@(posedge iCLK_18_4 or negedge iRST_N)
begin
	if(!iRST_N)
	begin
		BCK_DIV		<=	0;
		AUD_BCLK		<=	0;
	end
	else
	begin
		if(BCK_DIV >= REF_CLK/(SAMPLE_RATE*( `DATA_WIDTH )*CHANNEL_NUM*2)-1 )
		begin
			BCK_DIV		<=	0;
			AUD_BCLK		<=	~AUD_BCLK;
		end
		else
		BCK_DIV		<=	BCK_DIV+1;
	end
end
//////////////////////////////////////////////////
////////////	AUD_LRCK Generator	//////////////
always@(posedge iCLK_18_4 or negedge iRST_N)
begin
	if(!iRST_N)
	begin
		LRCK_1X_DIV	<=	0;
		LRCK_1X		<=	0;
	end
	else
	begin
		//	LRCK 1X
		if(LRCK_1X_DIV >= REF_CLK/(SAMPLE_RATE*2)-1 )
		begin
			LRCK_1X_DIV	<=	0;
			LRCK_1X	<=	~LRCK_1X;
		end
		else
			LRCK_1X_DIV		<=	LRCK_1X_DIV+1;
	end
end
assign	AUD_DACLRCK	=	LRCK_1X;



always@(negedge AUD_BCLK or negedge iRST_N)
begin
	if(!iRST_N)
		SEL_Cont	<=	0;
	else
		SEL_Cont	<=	SEL_Cont+1;
end
assign	oAUD_DACDAT	=	value[~SEL_Cont];






endmodule

