module DDS (clock,    //clock at fs
				FTV,	  //Frequency tuning value
				dataOut   //DATA_WIDETH bits data value we want to output.
				);
input 			clock;							
input [8:0] 	FTV;
output reg		[`DATA_WIDTH-1:0]	dataOut;  	//Data to output.
reg	[9:0] counter;


//////////	DDS goes here, use negedge clock as the clock //////////////
always@(negedge clock)
	counter <= counter + FTV;
   
   
always@*
begin
    case(counter[9:6])
			 0 : dataOut   <= 0;
			 1 : dataOut   <= 12539;
			 2 : dataOut   <= 23170;
			 3 : dataOut   <= 30273;
			 4 : dataOut   <= 32767;
			 5 : dataOut   <= 30273;
			 6 : dataOut   <= 23170;
			 7 : dataOut   <= 12539;
			 8 : dataOut   <= 0;
			 9 : dataOut   <= -12539;
			10 : dataOut   <= -23170;
			11 : dataOut   <= -30273;
			12 : dataOut   <= -32767;
			13 : dataOut   <= -30273;
			14 : dataOut   <= -23170;
			15 : dataOut   <= -12539;
	default	:
		   dataOut		<=		0		;
	endcase
end
endmodule 