`define DATA_WIDTH 16  // Number of bits to output.

module top
	(
		////////////////////	Clock Input	 	////////////////////	 
		iCLK_50,							//	50 MHz						//	External Clock
		
		////////////////////	Switch values	////////////////////
		iSW,								//	switches
		
		////////////////	Audio CODEC		////////////////////////
		AUD_ADCLRCK,					//	Audio CODEC ADC LR Clock
		iAUD_ADCDAT,					//	Audio CODEC ADC Data
		AUD_DACLRCK,					//	Audio CODEC DAC LR Clock
		oAUD_DACDAT,					//	Audio CODEC DAC Data
		AUD_BCLK,						//	Audio CODEC Bit-Stream Clock
		oAUD_XCK							//	Audio CODEC Chip Clock
	);
	
////////////////////////	Clock Input	 	////////////////////////
input			iCLK_50;				//	50 MHz
////////////////////////	Push Button		////////////////////////

////////////////////////	DPDT Switch		////////////////////////
input	[8:0]	iSW;					//	Toggle Switch[8:0]

////////////////////	Audio CODEC		////////////////////////////
inout			AUD_ADCLRCK;			//	Audio CODEC ADC LR Clock
input			iAUD_ADCDAT;			//	Audio CODEC ADC Data
inout			AUD_DACLRCK;			//	Audio CODEC DAC LR Clock
output		oAUD_DACDAT;			//	Audio CODEC DAC Data
inout			AUD_BCLK;				//	Audio CODEC Bit-Stream Clock
output		oAUD_XCK;				//	Audio CODEC Chip Clock

///////////////// Define local variables  ///////////////////////////
wire		[`DATA_WIDTH-1:0] DataOut;

// Create the Audio interface
AUDIO audio_inst1 (
		iCLK_50,							//	50 MHz External Clock
		DataOut,							//	value to output
		////////////////	Audio CODEC		////////////////////////
		AUD_ADCLRCK,					//	Audio CODEC ADC LR Clock
		iAUD_ADCDAT,					//	Audio CODEC ADC Data
		AUD_DACLRCK,					//	Audio CODEC DAC LR Clock
		oAUD_DACDAT,					//	Audio CODEC DAC Data
		AUD_BCLK,						//	Audio CODEC Bit-Stream Clock
		oAUD_XCK,						//	Audio CODEC Chip Clock
		);

DDS dds_inst1 (
		AUD_DACLRCK,					// What we will use as the clock for DDS
		iSW,								// Switches
		DataOut							// output from DDS.
		);

endmodule 