close all
clear all
fs = 48000; % sampling rate
screenWidth = 640;
tArr = 0:1:(screenWidth-1); % This is your time array, or pixel indices

% in order to see 2 periods on the sceen, we need to have
L = 320/fs; % Length of the sawtooth
f = 1/L; % fundamental frequency
sum = zeros (1, length(tArr)); % sum of the Fourier series

sineTable = [0,804,1608,2410,3212,4011,4808,5602,6393,7179,7962,8739,9512,10278,11039,11793,12539,13279,14010,14732,15446,16151,16846,17530,18204,18868,19519,20159,20787,21403,22005,22594,23170,23731,24279,24811,25329,25832,26319,26790,27245,27683,28105,28510,28898,29268,29621,29956,30273,30571,30852,31113,31356,31580,31785,31971,32137,32285,32412,32521,32609,32678,32728,32757,32767,32757,32728,32678,32609,32521,32412,32285,32137,31971,31785,31580,31356,31113,30852,30571,30273,29956,29621,29268,28898,28510,28105,27683,27245,26790,26319,25832,25329,24811,24279,23731,23170,22594,22005,21403,20787,20159,19519,18868,18204,17530,16846,16151,15446,14732,14010,13279,12539,11793,11039,10278,9512,8739,7962,7179,6393,5602,4808,4011,3212,2410,1608,804,0,-804,-1608,-2410,-3212,-4011,-4808,-5602,-6393,-7179,-7962,-8739,-9512,-10278,-11039,-11793,-12539,-13279,-14010,-14732,-15446,-16151,-16846,-17530,-18204,-18868,-19519,-20159,-20787,-21403,-22005,-22594,-23170,-23731,-24279,-24811,-25329,-25832,-26319,-26790,-27245,-27683,-28105,-28510,-28898,-29268,-29621,-29956,-30273,-30571,-30852,-31113,-31356,-31580,-31785,-31971,-32137,-32285,-32412,-32521,-32609,-32678,-32728,-32757,-32767,-32757,-32728,-32678,-32609,-32521,-32412,-32285,-32137,-31971,-31785,-31580,-31356,-31113,-30852,-30571,-30273,-29956,-29621,-29268,-28898,-28510,-28105,-27683,-27245,-26790,-26319,-25832,-25329,-24811,-24279,-23731,-23170,-22594,-22005,-21403,-20787,-20159,-19519,-18868,-18204,-17530,-16846,-16151,-15446,-14732,-14010,-13279,-12539,-11793,-11039,-10278,-9512,-8739,-7962,-7179,-6393,-5602,-4808,-4011,-3212,-2410,-1608,-804];
tableSize = length(sineTable);
B_A = log2(tableSize); % number of bits to index the sine table
B_FTV = 16; % size of the counter register

for i = 1 : 4
    a = __blank__ ; % Fourier coefficients
    aQ15 = round(a * 32768); % Fourier coefficients are always between 0 and 1, so use 16-bit Q15
    FTV =  round(__blank__); % FTV for frequency = i*f
    DDSoutput = zeros(1,screenWidth);
    counter = 0;
    % Now the DDS
    for j = 1:screenWidth
        counter = counter + FTV; % counter is B_FTV bits long
        counter = mod(counter, 2^B_FTV); % Everything is double in MATLAB, so we need to wrap around ourselves
        DDSoutput(j) = sineTable(floor(counter/2^(B_FTV-B_A))+1); % add 1 because MATLAB index starts at 1
    end
    sum = sum - aQ15 * DDSoutput; % sum is Q30 because DDSoutput is Q15
end
sawtoothWave = sum / 32768; % to Q15
scaledSawtooth = sawtoothWave * 200/32768 ; % Scale to VGA
outputToVGA = round(scaledSawtooth + 250); % VGA offset
plot(tArr,outputToVGA,'LineWidth',5) % you should see the same thing on your VGA display when using FPGA instead of MATLAB
title('VGA output of the Sawtooth')


% for b=0:tableSize-1
%     fprintf('\t\t\t%2d : dataOut   <= %d;\n',b,sineTable(b+1))
% end